﻿using System;
using System.Runtime.InteropServices;

namespace AppControlManager;

internal sealed partial class Win32InteropInternal
{
	// https://learn.microsoft.com/en-us/windows/win32/api/winuser/nf-winuser-getwindowplacement
	[LibraryImport("user32.dll", SetLastError = true)]
	[DefaultDllImportSearchPaths(DllImportSearchPath.System32)]
	[return: MarshalAs(UnmanagedType.Bool)]
	internal static partial bool GetWindowPlacement(IntPtr hWnd, ref WINDOWPLACEMENT lpwndpl);

	[StructLayout(LayoutKind.Sequential)]
	internal struct WINDOWPLACEMENT
	{
		internal int length;
		internal int flags;
		internal ShowWindowCommands showCmd;
		internal POINT ptMinPosition;
		internal POINT ptMaxPosition;
		internal RECT rcNormalPosition;
	}

	internal enum ShowWindowCommands
	{
		SW_HIDE = 0,
		SW_SHOWNORMAL = 1,
		SW_SHOWMINIMIZED = 2,
		SW_SHOWMAXIMIZED = 3,
		SW_SHOWNOACTIVATE = 4,
		SW_SHOW = 5,
		SW_MINIMIZE = 6,
		SW_SHOWMINNOACTIVE = 7,
		SW_SHOWNA = 8,
		SW_RESTORE = 9,
		SW_SHOWDEFAULT = 10,
		SW_FORCEMINIMIZE = 11
	}

	[StructLayout(LayoutKind.Sequential)]
	internal struct POINT
	{
		internal int x;
		internal int y;
	}

	[StructLayout(LayoutKind.Sequential)]
	internal struct RECT
	{
		internal int left;
		internal int top;
		internal int right;
		internal int bottom;
	}
}
